long Spannung1024;                  // Hier wird eine Variable namens "Spannung1024" des Typs Long angelegt.
float Spannung5V;                   // Hier wird eine Variable namens "Spannung5V" des Typs Float angelegt.


void setup () {
  Serial.begin(9600);               // Hier wird der serielle Monitor initialisiert (9600 Signaländerungen/Sekunde)

  pinMode (9, OUTPUT);              // digitaler PINin 9 wird als OUTPUT (also Ausgang) festgelegt
  pinMode (A0, INPUT);              // analoger PIN 0 wird als INPUT (also Eingang) festgelegt.
                                    // Analoge Pins geben einen Wert von 0 bis 1023 wieder (haben also eine Auflösung von 1024 Schritten). 
                                    // Der Wer ist abhängig von der anliegenden Spannung: 0 = 0V und 1023 = 5V. Entsprechend muss umgerechnet werden
  
  }                                 // Ende Setup

void loop () {
  digitalWrite (9, HIGH);           // Setzt den PIN 9 auf HIGH (5V) und schaltet damit die LED an
  
  Spannung1024 = analogRead (A0);   // Der Wert des analogen Pins 0 (die Werte nehmen 0 bis 1023 an) wird ausgelesen und der Variablen "Spannung1024" zugewiesen
  Serial.println (Spannung1024);    // Mit diesem Befehl wid auf den seriellen Monitor der Wert der Variablen Spannung1024 geschrieben 

  Spannung5V =  (3.0 / 1024.0) * Spannung1024;    // Mit diesem Befehl wird eine Variable aus einer anderen Variable berechnet. Die Umrechnung wird in einem späteren Aufgabenteil noch angepasst. 
    
  delay (1000);                     // Warten für 1000 millisekunden ( = 1 Sekunde)
  digitalWrite (9, LOW);            // Setzt den PIN 9 auf LOW (0V) und schaltet damit die LED aus
  
  }                                 // Ende Loop




/*  P2_Lichtstaerkesensor_14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************

    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Aruino hoch. Wenn alles geklappt hat, blinkt die LED. 


    2   AUSGABE AUF SERIELLEM MONITOR ÜBERPRÜFEN - Das Programm gibt Rohwerte des Fotowiderstandes auf dem seriellen Monitor aus. 
        Lassen Sie sich diese Rohwerte anzeigen, indem Sie den seriellen Monitor in der Arduino-IDE öffnen (z.B. die Lupe oben rechts klicken).
        Ändern Sie die Lichtverhältnisse auf dem Fotowiderstand und prüfen dabei, ob sich die Rohdaten auf dem seriellen Monitor ändern. 


    3   AUSGABE AUF SERIELLEM MONITOR ANPASSEN I - Auf dem seriellen Monitor kommen die Rohwerte direkt hintereinander. Das ist aber nicht sehr übersichtlich.
        Beschriften Sie die Ausgabe auf dem seriellen Monitor (bspw. „Rohwert: <WERT>“). Verwenden Sie dafür den Befehl Serial.println ("Text"); Fügen Sie eine Pause zwischen den einzelnen Ausgaben von einer halben Sekunde ein. 
        Was sind die minimalen und die maximalen Werte, die der Arduino ausgibt?


    4   VARIABLEN UMRECHNEN - Je nach angelegter Spannung (max. bis 5V) am analogen Eingang gibt der Arduino Rohwerte von 0 bis 1023 (Counts) wieder. 
        Lassen Sie den Arduino diese Rowerte in eine Spannung umrechnen und den Wert auf dem seriellen Monitor ausgeben.

        Hinweis: Der Befehl für die Umrechnung von der Variablen Spannung1024 in Spannung5V steht bereits im Programmcode, muss aber noch angepasst werden.


    5   AUSGABE AUF SERIELLEM MONITOR ANPASSEN II - Machen Sie es übersichtlich. Geben Sie den Rohwert und die die Spannung wie folgt auf dem seriellen Monitor aus:         
        „Rohwert: <WERT> - Spannung: <WERT>“
             
    
    6   ANSTEUERN DER LED - Nutzen Sie den Arduino, um die LED in Abhängigkeit des Lichtstärkesensors anzusteuern. 
        Wenn es „dunkel“ ist, wird die LED angeschaltet, wenn es „hell“ ist, geht die LED wieder aus. (Tipp: If-Else-Schleife verwenden)


    7   HELL ODER DUNKEL? - Geben Sie als Text auf dem seriellen Monitor zusätzlich aus, ob es „hell“ oder „dunkel“ ist.


    8   EXPORT UND IMPORT IN EXCEL - Erstellen Sie ein Zeit-Helligkeitsdiagramm mit mind. 20 Wertepaaren in Excel. Gehen Sie dafür folgendermaßen vor: 
        1. Passen Sie die Ausgabe der Werte auf dem Seriellen Monitor für den Export an. Lassen Sie sich z.B. einen Wert (ohne Einheit oder sonstige Informationen) pro Zeile ausgeben.
        2. Passen Sie die Ausgabe so an, dass ein Wert pro  Zeiteinheit (bspw. 1/4 Sekunde) geschrieben wird. Dies entspricht dann dem Messintervall. 
        3. Kopieren Sie die ausgegebenen Werte des seriellen Monitors direkt in Excel.
        4. Fügen Sie die Zeitinformation in Excel hinzu. Bei einem Messintervall von 1/4 Sekunde bspw. 0, 0,25, 0,5, 0,75, 1, usw.
        5. Erstellen Sie ein Zeit-Helligkeitsdiagramm und beschriften Sie die Achsen.

        
    9   DIMMEN EINER LED - Nutzen Sie die Pulsweitenmodulation (PWM) und lassen Sie die LED bei „halbdunkel“ gedimmt leuchten.
        Verwenden Sie dazu den Befehl  >> analogWrite(6, 100); << und spielen Sie mit den letzten Wert (0-255).

    10  WIE OFT WAR ES DUNKEL? - Programmieren Sie ein Zählwerk und geben Sie als Ergebnis auf dem seriellen Monitor aus, wie oft der Sensor verdunkelt wurde.


   
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************

    4   VARIABLEN UMRECHNEN - LÖSUNGSHINWEISE
        - Welcher Spannung entspricht der Wert 0 und welcher 1023?
        - Wie groß ist die Spannungsdifferenz von z.B. 0 bis 1 oder 430 zu 431? (Tipp: Maximalen Bereich durch Anzahl möglicher Counts dividieren)


    6   ANSTEUERN DER LED - LÖSUNGSHINWEISE
        - Nutzen Sie eine if-else-schleife

        if (Spannung1024 < 500) {
        ... ; 
        }
        else {... ; }

    10  WIE OFT WAR ES DUNKEL? - LÖSUNGSHINWEIS
        - Lassen Sie pro Dunkel-Änderung eine Variable hochzählen, Bspw. x = x+1; und geben Sie diese aus.

    **********************************************************
    LÖSUNGEN
    **********************************************************
    
    
    4   VARIABLEN UMRECHNEN - LÖSUNGSHINWEISE
        Spannung5V = (Spannung1024 * 5.0) / 1024.0 ;    


    6   ANSTEUERN DER LED - LÖSUNG
 
        if (Spannung1024 < 500) {
        digitalWrite (9, LOW);  
        }
        else {digitalWrite (9, HIGH); }


    8   EXPORT UND IMPORT IN EXCEL - LÖSUNG
        Nutzen Sie lediglich den folgenden Befehl für den seriellen Monitor und nur ein Delay. 
        Alle anderen Befehle für den seriellen Monitor und Delays müssen Auskommentiert werden.   
        Serial.println (Spannung1024);
        delay (250);   


        */ 

  
